/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographInHandRenderer;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    private ItemStack f_109300_;
    @Shadow
    private ItemStack f_109301_;

    @Shadow
    protected abstract void m_109346_(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Shadow
    protected abstract float m_109312_(float var1);

    @Shadow
    protected abstract void m_109361_(PoseStack var1, MultiBufferSource var2, int var3, HumanoidArm var4);

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void renderPhotograph(AbstractClientPlayer player, float partialTicks, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, CallbackInfo ci, boolean isMainHand, HumanoidArm arm) {
        if (ViewfinderClient.isLookingThrough()) {
            poseStack.m_85849_();
            ci.cancel();
            return;
        }
        if (stack.m_41720_() instanceof PhotographItem || stack.m_41720_() instanceof StackedPhotographsItem) {
            if (isMainHand && this.f_109301_.m_41619_()) {
                this.exposure$renderTwoHandedPhotograph(player, poseStack, buffer, combinedLight, pitch, equipProgress, swingProgress);
            } else {
                this.exposure$renderOneHandedPhotograph(player, poseStack, buffer, combinedLight, equipProgress, arm, swingProgress, stack);
            }
            poseStack.m_85849_();
            ci.cancel();
        }
    }

    @Unique
    private void exposure$renderOneHandedPhotograph(AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float pEquippedProgress, HumanoidArm pHand, float pSwingProgress, ItemStack stack) {
        float f = pHand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_85837_((double)(f * 0.125f), -0.125, 0.0);
        if (!player.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * 10.0f));
            this.m_109346_(poseStack, buffer, combinedLight, pEquippedProgress, pSwingProgress, pHand);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)(f * 0.51f), (double)(-0.08f + pEquippedProgress * -1.2f), -0.75);
        float f1 = Mth.m_14116_((float)pSwingProgress);
        float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.m_14031_((float)(pSwingProgress * (float)Math.PI));
        poseStack.m_85837_((double)(f * f3), (double)(f4 - 0.3f * f2), (double)f5);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * -45.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * f2 * -30.0f));
        PhotographInHandRenderer.renderPhotograph(poseStack, buffer, combinedLight, stack);
        poseStack.m_85849_();
    }

    @Unique
    private void exposure$renderTwoHandedPhotograph(AbstractClientPlayer player, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, float pPitch, float pEquippedProgress, float pSwingProgress) {
        float f = Mth.m_14116_((float)pSwingProgress);
        float f1 = -0.2f * Mth.m_14031_((float)(pSwingProgress * (float)Math.PI));
        float f2 = -0.4f * Mth.m_14031_((float)(f * (float)Math.PI));
        pMatrixStack.m_85837_(0.0, (double)(-f1 / 2.0f), (double)f2);
        float f3 = this.m_109312_(pPitch);
        pMatrixStack.m_85837_(0.0, (double)(0.04f + pEquippedProgress * -1.2f + f3 * -0.5f), (double)-0.72f);
        pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f3 * -85.0f));
        if (!player.m_20145_()) {
            pMatrixStack.m_85836_();
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            this.m_109361_(pMatrixStack, pBuffer, pCombinedLight, HumanoidArm.RIGHT);
            this.m_109361_(pMatrixStack, pBuffer, pCombinedLight, HumanoidArm.LEFT);
            pMatrixStack.m_85849_();
        }
        float f4 = Mth.m_14031_((float)(f * (float)Math.PI));
        pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f4 * 20.0f));
        pMatrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        PhotographInHandRenderer.renderPhotograph(pMatrixStack, pBuffer, pCombinedLight, this.f_109300_);
    }
}

